package ru.yandex.calendar.logic.domain;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.function.Function0;
import ru.yandex.inside.passport.blackbox.PassportAuthDomain;

/**
 * @author Stepan Koltsov
 * @author ssytnik
 */
public class PassportAuthDomainsHolder {
    public static final PassportAuthDomainsHolder H = new PassportAuthDomainsHolder();

    private PassportAuthDomains domains;

    private PassportAuthDomainsHolder() {
    }

    public SetF<PassportAuthDomain> getPassportAuthDomains() {
        return domains.get();
    }

    public PassportAuthDomains getDomains() {
        return domains;
    }

    public Option<PassportAuthDomain> getDefaultDomain() {
        if (getPassportAuthDomains().size() == 1) {
            return getPassportAuthDomains().singleO();
        } else {
            return Option.empty();
        }
    }

    public boolean contains(PassportAuthDomain domain) {
        return getPassportAuthDomains().containsTs(domain);
    }

    public boolean containsYandexTeamRu() {
        return contains(PassportAuthDomain.YANDEX_TEAM_RU);
    }

    public boolean containsPublic() { return contains(PassportAuthDomain.PUBLIC); }

    public String asString() {
        return domains.name().toLowerCase();
    }

    @Required
    @Value("${auth.domains}")
    public void setDomains(String domains) {
        this.domains = PassportAuthDomains.byProperty(domains);
    }

    public void setDomainsForTest(PassportAuthDomains domains) {
        this.domains = domains;
    }

    public <T> T withDomainsForTest(String domains, Function0<T> action) {
        PassportAuthDomains stashed = this.domains;
        this.domains = PassportAuthDomains.byProperty(domains);
        try {
            return action.apply();
        } finally {
            this.domains = stashed;
        }
    }
} //~
