package ru.yandex.calendar.logic.event;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

public enum ActionSource implements StringEnum {
    UNKNOWN,
    WEB,
    WEB_ICS,
    WEB_MAYA,
    WEB_FOR_STAFF,
    CALDAV,
    EXCHANGE,
    EXCHANGE_PULL,
    EXCHANGE_SYNCH,
    EXCHANGE_ASYNCH,
    MAILHOOK,
    MAIL,
    INTERNAL_API,
    MOBILE,
    PERFORMER,
    WORKER,
    STAFF,
    DB_REPAIRER,
    KIOSK,
    DISPLAY,
    INVITER,
    XIVA
    ;

    public boolean isFromExchange() {
        return this == EXCHANGE || this == EXCHANGE_SYNCH || this == EXCHANGE_ASYNCH || this == EXCHANGE_PULL;
    }

    public boolean isByExchangeNotification() {
        return this == EXCHANGE || this == EXCHANGE_PULL;
    }

    public boolean isTrusted() {
        return isFromExchange() || isFromExchangeOrMail() || this == DB_REPAIRER;
    }

    public static ActionSource notTrusted() {
        return ActionSource.WEB;
    }

    public boolean isFromMailOrHook() {
        return this == MAILHOOK || this == MAIL;
    }

    public boolean isFromMailHook() {
        return this == MAILHOOK;
    }

    public boolean isCaldav() {
        return this == CALDAV;
    }

    public boolean isFromExchangeOrMail() {
        return isFromExchange() || isFromMailOrHook();
    }

    public boolean isWeb() {
        return this == WEB || this == WEB_FOR_STAFF || this == WEB_MAYA;
    }

    public boolean isWebOrApi() {
        return isWeb() || this == INTERNAL_API || this == INVITER;
    }

    public boolean isStaff() {
        return this == STAFF || this == WEB_FOR_STAFF;
    }

    public boolean isInvitationMailsFree() {
        return isFromMailOrHook() || isFromExchangeOrMail() || this == WEB_ICS;
    }

    public static final StringEnumResolver<ActionSource> R = StringEnumResolver.r(ActionSource.class);

    public String toDbValue() { return CamelWords.parse(this.name()).toDbName(); }

    @Override
    public String value() {
        return toDbValue();
    }
}
