package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.calendar.logic.user.UserInfo;
import ru.yandex.inside.passport.PassportUid;

public class ActorId {
    private final Option<UidOrResourceId> uidOrResourceId;

    private ActorId(Option<UidOrResourceId> uidOrResourceId) {
        this.uidOrResourceId = uidOrResourceId;
    }

    public static ActorId yaCalendar() {
        return new ActorId(Option.<UidOrResourceId>empty());
    }

    public static ActorId userOrResource(UidOrResourceId uidOrResourceId) {
        return new ActorId(Option.of(uidOrResourceId));
    }

    public static ActorId user(PassportUid uid) {
        return new ActorId(Option.of(UidOrResourceId.user(uid)));
    }

    public static ActorId user(UserInfo user) {
        return user(user.getUid());
    }

    public static ActorId resource(long resourceId) {
        return new ActorId(Option.of(UidOrResourceId.resource(resourceId)));
    }

    public boolean isUser() {
        return uidOrResourceId.exists(UidOrResourceId.isUserF());
    }

    public boolean isResource() {
        return uidOrResourceId.exists(UidOrResourceId.isUserF().notF());
    }

    public boolean isYaCalendar() {
        return !uidOrResourceId.isPresent();
    }

    public PassportUid getUid() {
        return uidOrResourceId.getOrThrow("ya-calendar").getUid();
    }

    public long getResourceId() {
        return uidOrResourceId.getOrThrow("ya-calendar").getResourceId();
    }

    public Option<PassportUid> getUidO() {
        return uidOrResourceId.filterMap(UidOrResourceId.getUidOF());
    }

    public UidOrResourceId getUidOrResourceId() {
        return isUser() ? UidOrResourceId.user(getUid()) : UidOrResourceId.resource(getResourceId());
    }

    public boolean isUserWithSomeOfUids(CollectionF<PassportUid> uids) {
        return isUser() && uids.containsTs(getUid());
    }

    public String toSerializedString() {
        return !uidOrResourceId.isPresent() ? "ya-calendar"
                : uidOrResourceId.get().isUser() ? uidOrResourceId.get().getUid().toString()
                : "resource:" + uidOrResourceId.get().getResourceId();
    }
}
