package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.event.repetition.EventAndRepetition;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.sending.EventSendingInfo;
import ru.yandex.calendar.logic.sending.param.EventOnLayerChangeMessageParameters;

/**
 * Event creation info.
 * For inner usage (ER.create* routines) only.
 * @author ssytnik
 */
public class CreateInfo {
    /**
     * Created event id
     */
    private final EventAndRepetition eventAndRepetition;
    private final Option<String> externalId;
    /**
     * If new layer was created "on demand", than we should remember
     * its id to return it to the UI, otherwise contains id of the layer,
     * to which event was added.
     */
    private final Option<Long> layerId;
    private final ListF<Long> participantsLayerIds;

    private final ListF<EventSendingInfo> sendingInfos;
    private final ListF<EventOnLayerChangeMessageParameters> layerNotifyMails;

    public CreateInfo(
            EventAndRepetition eventAndRepetition, Option<String> externalId,
            Option<Long> layerId, ListF<Long> participantsLayerIds,
            ListF<EventSendingInfo> sendingInfos, ListF<EventOnLayerChangeMessageParameters> layerNotifyMails)
    {
        this.eventAndRepetition = eventAndRepetition;
        this.externalId = externalId;
        this.layerId = layerId;
        this.participantsLayerIds = participantsLayerIds;
        this.sendingInfos = sendingInfos;
        this.layerNotifyMails = layerNotifyMails;
    }

    public CreateInfo(EventAndRepetition eventAndRepetition, Option<Long> layerId) {
        this(eventAndRepetition, Option.empty(), layerId, Cf.list(), Cf.list(), Cf.list());
    }

    public long getEventId() {
        return eventAndRepetition.getEvent().getId();
    }

    public Event getEvent() {
        return eventAndRepetition.getEvent();
    }

    public EventAndRepetition getEventAndRepetition() {
        return eventAndRepetition;
    }

    public RepetitionInstanceInfo getRepetitionInfo() {
        return eventAndRepetition.getRepetitionInfo();
    }

    public Option<String> getExternalId() {
        return externalId;
    }

    public Option<Long> getLayerId() {
        return layerId;
    }

    public ListF<Long> getAllLayerIds() {
        return layerId.plus(participantsLayerIds);
    }

    public ListF<EventSendingInfo> getSendingInfos() {
        return sendingInfos;
    }

    public ListF<EventOnLayerChangeMessageParameters> getLayerNotifyMails() {
        return layerNotifyMails;
    }

}
