package ru.yandex.calendar.logic.event;

import lombok.With;

import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

@Bendable
@With
public class EventActions {
    @BenderPart
    private final boolean accept;
    @BenderPart
    private final boolean reject;
    @BenderPart
    private final boolean delete;
    @BenderPart
    private final boolean attach;
    @BenderPart
    private final boolean detach;
    @BenderPart
    private final boolean edit;
    @BenderPart
    private final boolean invite;
    @BenderPart
    private final boolean move;
    @BenderPart
    private final boolean changeOrganizer;

    public EventActions(
            boolean accept, boolean reject, boolean delete,
            boolean attach, boolean detach,
            boolean edit, boolean invite, boolean move,
            boolean changeOrganizer)
    {
        this.accept = accept;
        this.reject = reject;
        this.delete = delete;
        this.attach = attach;
        this.detach = detach;
        this.edit = edit;
        this.invite = invite;
        this.move = move;
        this.changeOrganizer = changeOrganizer;
    }

    public boolean canAccept() {
        return accept;
    }

    public boolean canReject() {
        return reject;
    }

    public boolean canDelete() {
        return delete;
    }

    public boolean canAttach() {
        return attach;
    }

    public boolean canDetach() {
        return detach;
    }

    public boolean canEdit() {
        return edit;
    }

    public boolean canInvite() {
        return invite;
    }

    public static EventActions empty() {
        return new EventActions(false, false, false, false, false, false, false, false, false);
    }
}
