package ru.yandex.calendar.logic.event;

import ru.yandex.calendar.logic.event.repetition.EventAndRepetition;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;

/**
 * @author dbrylev
 */
public class EventAndRelations {
    private final EventWithRelations event;
    private final RepetitionInstanceInfo repetition;

    public EventAndRelations(EventWithRelations event, RepetitionInstanceInfo repetition) {
        this.event = event;
        this.repetition = repetition;
    }

    public EventWithRelations getEvent() {
        return event;
    }

    public RepetitionInstanceInfo getRepetition() {
        return repetition;
    }

    public EventAndRepetition getEventAndRepetition() {
        return new EventAndRepetition(getEvent().getEvent(), getRepetition());
    }

    public long getEventId() {
        return event.getId();
    }
}
