package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.lang.Validate;

/**
 * @author dbrylev
 */
public class EventAttachedLayerId {
    private final Option<Long> layerId;
    private final Option<Long> prevLayerId;

    private EventAttachedLayerId(Option<Long> layerId, Option<Long> prevLayerId) {
        Validate.some(layerId.orElse(prevLayerId));

        this.layerId = layerId;
        this.prevLayerId = prevLayerId;
    }

    public static EventAttachedLayerId reattached(long prevLayerId, long layerId) {
        return new EventAttachedLayerId(Option.of(layerId), Option.of(prevLayerId));
    }

    public static EventAttachedLayerId attached(long layerId) {
        return new EventAttachedLayerId(Option.of(layerId), Option.<Long>empty());
    }

    public static EventAttachedLayerId alreadyAttached(long layerId) {
        return new EventAttachedLayerId(Option.of(layerId), Option.of(layerId));
    }

    public static EventAttachedLayerId detached(long fromLayerId) {
        return new EventAttachedLayerId(Option.<Long>empty(), Option.of(fromLayerId));
    }

    public long getCurrentLayerId() {
        return layerId.get();
    }

    public Option<Long> getAttachedId() {
        return prevLayerId.isPresent() && prevLayerId.equals(layerId) ? Option.<Long>empty() : layerId;
    }

    public Option<Long> getDetachedId() {
        return prevLayerId.isPresent() && prevLayerId.equals(layerId) ? Option.<Long>empty() : prevLayerId;
    }

    public ListF<Long> getAllLayerIds() {
        return prevLayerId.plus(layerId);
    }

    public static Function1B<EventAttachedLayerId> wasAttachOrDetachF() {
        return id -> id.getAttachedId().isPresent() || id.getDetachedId().isPresent();
    }

    public static Function<EventAttachedLayerId, ListF<Long>> getAllLayerIdsF() {
        return id -> id.getAllLayerIds();
    }
}
