package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.event.model.EventUserUpdate;
import ru.yandex.calendar.logic.log.change.changes.EventFieldsChangesJson;

public class EventAttachedUser {
    public final Event event;
    public final EventFieldsChangesJson eventChanges;
    public final EventUserUpdate eventUser;
    public final Option<EventAttachedLayerId> layerId;

    public EventAttachedUser(
            Event event, EventFieldsChangesJson eventChanges, EventUserUpdate eventUser, Option<EventAttachedLayerId> layerId)
    {
        this.event = event;
        this.eventChanges = eventChanges;
        this.eventUser = eventUser;
        this.layerId = layerId;
    }

    public EventAttachedUser withEventSequenceIncremented() {
        return new EventAttachedUser(event, EventFieldsChangesJson.incrementedSequence(event), eventUser, layerId);
    }
}
