package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.sharing.EventParticipantsChangesInfo;
import ru.yandex.calendar.logic.sharing.participant.ParticipantData;
import ru.yandex.calendar.logic.sharing.participant.ParticipantId;
import ru.yandex.calendar.logic.sharing.participant.ParticipantInfo;
import ru.yandex.calendar.logic.sharing.participant.ResourceParticipantInfo;
import ru.yandex.calendar.logic.sharing.participant.UserParticipantInfo;

/**
 * @author dbrylev
 */
public class EventChangesInfoForMails {

    public static final EventChangesInfoForMails EMPTY = new EventChangesInfoForMails(
            false, false, false, false, EventParticipantsChangesInfo.EMPTY);

    private final boolean nameChanged;
    private final boolean descriptionChanged;
    private final boolean locationChanged;
    private final boolean timeOrRepetitionChanged;
    private final EventParticipantsChangesInfo participantsChanges;

    public EventChangesInfoForMails(
            boolean nameChanged, boolean descriptionChanged,
            boolean locationChanged, boolean timeOrRepetitionChanged,
            EventParticipantsChangesInfo participantsChanges)
    {
        this.nameChanged = nameChanged;
        this.descriptionChanged = descriptionChanged;
        this.locationChanged = locationChanged;
        this.timeOrRepetitionChanged = timeOrRepetitionChanged;
        this.participantsChanges = participantsChanges;
    }

    public static EventChangesInfoForMails timeOrRepetitionChanged() {
        return new EventChangesInfoForMails(false, false, false, true, EventParticipantsChangesInfo.EMPTY);
    }

    public boolean isEmpty() {
        return !isNameChanged() && !isDescriptionChanged()
                && !isLocationChanged() && !isTimeOrRepetitionChanged() && !isGuestsChanged();
    }

    public boolean isNameChanged() {
        return nameChanged;
    }

    public boolean isDescriptionChanged() {
        return descriptionChanged;
    }

    public boolean isLocationChanged() {
        return locationChanged;
    }

    public boolean isTimeOrRepetitionChanged() {
        return timeOrRepetitionChanged;
    }

    public boolean isOrganizerChanged() {
        return participantsChanges.wasOrganizerChange();
    }

    public boolean isGuestsChanged() {
        return getNewGuestsParticipantIds().isNotEmpty() || getRemovedGuests().isNotEmpty();
    }

    public EventParticipantsChangesInfo getParticipantsChanges() {
        return participantsChanges;
    }

    public ListF<ParticipantId> getNewGuestsParticipantIds() {
        return participantsChanges.getNewParticipants()
                .filterBy1(ParticipantId.isResourceF().notF())
                .filterBy2(ParticipantData.isOrganizerF().notF())
                .get1();
    }

    public ListF<UserParticipantInfo> getRemovedGuests() {
        return participantsChanges.getRemovedParticipants()
                .filter(ParticipantInfo.isOrganizerF().notF())
                .filterByType(UserParticipantInfo.class);
    }

    public ListF<ResourceInfo> getRemovedResources() {
        return participantsChanges.getRemovedParticipants()
                .filterByType(ResourceParticipantInfo.class)
                .map(ResourceParticipantInfo::getResourceInfo);
    }
}
