package ru.yandex.calendar.logic.event;

import lombok.val;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.frontend.web.cmd.run.ui.event.EventCmdManager;
import ru.yandex.calendar.logic.event.archive.ArchiveManager;
import ru.yandex.calendar.logic.event.attachment.MulcaGate;
import ru.yandex.calendar.logic.event.avail.absence.AbsenceUpdater;
import ru.yandex.calendar.logic.event.meeting.MeetingHandlerContextConfiguration;
import ru.yandex.calendar.logic.event.repetition.RepetitionContextConfiguration;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.logic.event.web.EventWebRemover;
import ru.yandex.calendar.logic.event.web.EventWebUpdater;
import ru.yandex.calendar.logic.log.EventsLogger;
import ru.yandex.calendar.logic.sending.so.SoChecker;
import ru.yandex.calendar.micro.MicroCoreContext;
import ru.yandex.calendar.micro.so.SoCheckClient;
import ru.yandex.misc.io.http.Timeout;

@Configuration
@Import({
    MeetingHandlerContextConfiguration.class,
    RepetitionContextConfiguration.class
})
public class EventContextConfiguration {

    @Bean
    public EventRoutines eventRoutines() {
        return new EventRoutines();
    }

    @Bean
    public EventDbManager eventDbManager() {
        return new EventDbManager();
    }

    @Bean
    public EventInfoDbLoader eventInfoDbLoader() {
        return new EventInfoDbLoader();
    }

    @Bean
    public EventWebManager eventWebManager() {
        return new EventWebManager();
    }

    @Bean
    public SoChecker soChecker(@Value("${so-check.url}") String url,
                               @Value("${so-check.http.connection_timeout}") int connectTimeout,
                               @Value("${so-check.http.socket_timeout}") int soTimeout,
                               MicroCoreContext microCoreContext) {
        val soCheckFormClient = microCoreContext.findBean(SoCheckClient.class);
        return new SoChecker(url, new Timeout(soTimeout, connectTimeout), soCheckFormClient);
    }

    @Bean
    public EventInvitationManager eventInvitationManager() {
        return new EventInvitationManager();
    }

    @Bean
    public EventsOnLayerChangeHandler eventsOnLayerChangeHandler() {
        return new EventsOnLayerChangeHandler();
    }

    @Bean
    public EventDeletionSmsHandler eventDeletionSmsHandler() {
        return new EventDeletionSmsHandler();
    }

    @Bean
    public EventMoveSmsHandler eventMoveSmsHandler() { return new EventMoveSmsHandler(); }

    @Bean
    public EventUserRoutines eventUserRoutines() {
        return new EventUserRoutines();
    }

    @Bean
    public EventInvitationRoutines eventInvitationRoutines() {
        return new EventInvitationRoutines();
    }

    @Bean
    public EventWebUpdater eventUpdater() {
        return new EventWebUpdater();
    }

    @Bean
    public EventWebRemover eventRemover() {
        return new EventWebRemover();
    }

    @Bean
    public EventChangesFinder eventChangesFinder() {
        return new EventChangesFinder();
    }

    @Bean
    public AbsenceUpdater absenceUpdater() {
        return new AbsenceUpdater();
    }

    @Bean
    public ArchiveManager archiveManager() {
        return new ArchiveManager();
    }

    @Bean
    public EventCmdManager eventCmdManager() {
        return new EventCmdManager();
    }

    @Bean
    public EventInstanceStatusChecker eventInstanceStatusChecker() {
        return new EventInstanceStatusChecker();
    }

    @Bean
    public MulcaGate mulcaGate() {
        return new MulcaGate();
    }

    @Bean
    public EventsLogger eventsLogger() {
        return new EventsLogger();
    }

} //~
