package ru.yandex.calendar.logic.event;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

import ru.yandex.bolts.collection.Either;

/**
 * @author dbrylev
 */
public class EventDateTime {
    private Either<Instant, LocalDate> dateTime;

    private EventDateTime(Either<Instant, LocalDate> dateTime) {
        this.dateTime = dateTime;
    }

    public static EventDateTime dateTime(Instant dateTime) {
        return new EventDateTime(Either.<Instant, LocalDate>left(dateTime));
    }

    public static EventDateTime date(LocalDate midnight) {
        return new EventDateTime(Either.<Instant, LocalDate>right(midnight));
    }

    public static EventDateTime cons(Instant ts, boolean allDay, DateTimeZone eventTz) {
        return allDay ? date(new LocalDate(ts, eventTz)) : dateTime(ts);
    }

    public Instant toInstant(DateTimeZone tz) {
        return isDate() ? getDate().toDateTimeAtStartOfDay(tz).toInstant() : getDateTime();
    }

    public DateTime toDateTime(DateTimeZone tz) {
        return new DateTime(toInstant(tz), tz);
    }

    public LocalDateTime toLocalDateTime(DateTimeZone tz) {
        return isDate() ? getDate().toLocalDateTime(LocalTime.MIDNIGHT) : new LocalDateTime(toInstant(tz), tz);
    }

    public boolean isDate() {
        return dateTime.isRight();
    }

    public LocalDate getDate() {
        return dateTime.getRight();
    }

    public Instant getDateTime() {
        return dateTime.getLeft();
    }
}
