package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventFields;
import ru.yandex.calendar.logic.beans.generated.EventHelper;
import ru.yandex.calendar.logic.beans.generated.MainEvent;
import ru.yandex.commune.mapObject.MapField;

public class EventGetProps {

    private final ListF<MapField<?>> eventFields;
    private final ListF<MapField<?>> mainEventFields;
    private final Option<Long> layerId;

    private final boolean eventParticipants;
    private final boolean eventResources;
    private final boolean eventWithRelations;

    private final boolean fullRepetitionInfo;

    private final boolean eventUserWithNotifications;
    private final boolean eventAttachments;
    private final boolean excludeSubscribers;

    private EventGetProps(
            ListF<MapField<?>> eventFields,
            ListF<MapField<?>> mainEventFields,
            Option<Long> layerId,
            boolean eventParticipants, boolean eventResources,
            boolean eventWithRelations, boolean fullRepetitionInfo,
            boolean eventUserWithNotifications, boolean eventAttachments,
            boolean excludeSubscribers)
    {
        this.eventFields = eventFields;
        this.mainEventFields = mainEventFields;
        this.layerId = layerId;
        this.eventParticipants = eventParticipants;
        this.eventResources = eventResources;
        this.eventWithRelations = eventWithRelations;
        this.fullRepetitionInfo = fullRepetitionInfo;
        this.eventUserWithNotifications = eventUserWithNotifications;
        this.eventAttachments = eventAttachments;
        this.excludeSubscribers = excludeSubscribers;
    }

    public static EventGetProps none() {
        return new EventGetProps(
                Cf.list(), Cf.list(), Option.empty(),
                false, false, false, false, false, false, false);
    }

    public static EventGetProps any() {
        return new EventGetProps(
                BeanHelper.getFields(Event.class), BeanHelper.getFields(MainEvent.class), Option.empty(),
                true, true, true, true, true, true,
                false);
    }

    public EventGetProps loadByLayerId(long layerId) {
        Builder b = builder();
        b.layerId = Option.of(layerId);
        return b.build();
    }

    public EventGetProps loadEventFields(ListF<MapField<?>> fields) {
        Builder b = builder();
        b.eventFields = fields;
        return b.build();
    }

    public EventGetProps loadMainEventField(ListF<MapField<?>> fields) {
        Builder b = builder();
        b.mainEventFields = fields;
        return b.build();
    }

    public EventGetProps loadEventAllFields() {
        Builder b = builder();
        b.eventFields = EventHelper.INSTANCE.beanMapObjectDescription().getFields();
        return b.build();
    }

    public EventGetProps loadEventParticipants() {
        Builder b = builder();
        b.eventParticipants = true;
        return b.build();
    }

    public EventGetProps loadEventResources() {
        Builder b = builder();
        b.eventResources = true;
        return b.build();
    }

    public EventGetProps loadEventWithRelations() {
        Builder b = builder();
        b.eventWithRelations = true;
        return b.build();
    }

    public EventGetProps loadEventWithRelationsWithSequenceNums() {
        Builder b = builder();
        b.eventWithRelations = true;
        b.eventFields.plus(EventFields.SEQUENCE);
        return b.build();
    }

    public EventGetProps loadFullRepetitionInfo() {
        Builder b = builder();
        b.fullRepetitionInfo = true;
        return b.build();
    }

    public EventGetProps excludeSubscribers() {
        Builder b = builder();
        b.excludeSubscribers = true;
        return b.build();
    }

    public EventGetProps loadEventUserWithNotifications() {
        Builder b = builder();
        b.eventUserWithNotifications = true;
        return b.build();
    }

    public EventGetProps loadEventAttachments() {
        Builder b = builder();
        b.eventAttachments = true;
        return b.build();
    }

    public ListF<MapField<?>> eventFieldsToLoad() {
        return eventFields;
    }

    public ListF<MapField<?>> mainEventFieldsToLoad() {
        return mainEventFields;
    }

    public Option<Long> getLayerId() {
        return layerId;
    }

    public boolean isWithEventParticipants() {
        return eventParticipants || eventWithRelations;
    }

    public boolean isWithEventResources() {
        return eventResources;
    }

    public boolean isWithEventWithRelations() {
        return eventWithRelations;
    }

    public boolean isWithFullRepetitionInfo() {
        return fullRepetitionInfo;
    }

    public boolean isWithEventUserWithNotifications() {
        return eventUserWithNotifications;
    }

    public boolean isWithEventAttachments() {
        return eventAttachments;
    }

    public boolean isIncludeSubscribers() {
        return !excludeSubscribers;
    }

    private Builder builder() {
        return new Builder(
                eventFields, mainEventFields, layerId, eventParticipants, eventResources,
                eventWithRelations, fullRepetitionInfo, eventUserWithNotifications, eventAttachments,
                excludeSubscribers);
    }

    private static class Builder {
        private ListF<MapField<?>> eventFields;
        private ListF<MapField<?>> mainEventFields;
        private Option<Long> layerId;
        private boolean eventParticipants;
        private boolean eventResources;
        private boolean eventWithRelations;

        private boolean fullRepetitionInfo;
        private boolean excludeSubscribers;

        private boolean eventUserWithNotifications;
        private boolean eventAttachments;

        Builder(ListF<MapField<?>> eventFields, ListF<MapField<?>> mainEventFields,
                Option<Long> layerId,
                boolean eventParticipants, boolean eventResources,
                boolean eventWithRelations, boolean fullRepetitionInfo,
                boolean eventUserWithNotifications, boolean eventAttachments,
                boolean excludeSubscribers)
        {
            this.eventFields = eventFields;
            this.mainEventFields = mainEventFields;
            this.layerId = layerId;
            this.eventParticipants = eventParticipants;
            this.eventResources = eventResources;
            this.eventWithRelations = eventWithRelations;
            this.fullRepetitionInfo = fullRepetitionInfo;
            this.eventUserWithNotifications = eventUserWithNotifications;
            this.eventAttachments = eventAttachments;
            this.excludeSubscribers = excludeSubscribers;
        }

        EventGetProps build() {
            return new EventGetProps(
                    eventFields, mainEventFields,
                    layerId,
                    eventParticipants, eventResources,
                    eventWithRelations, fullRepetitionInfo,
                    eventUserWithNotifications, eventAttachments,
                    excludeSubscribers);
        }
    }

}
