package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.function.forhuman.Comparator;

/**
 * @author Stepan Koltsov
 */
public class EventInstanceInfoComparator implements Comparator<EventInstanceInfo> {

    @Override
    public int compare(EventInstanceInfo o1, EventInstanceInfo o2) {
        int res = IntervalComparator.INSTANCE.compare(o1.getInterval(), o2.getInterval());

        if (res != 0) return res;

        boolean o1IsEmpty = !o1.getLayerId().isPresent() && !o1.getResourceId().isPresent();
        boolean o2IsEmpty = !o2.getLayerId().isPresent() && !o2.getResourceId().isPresent();

        if (o1IsEmpty || o2IsEmpty) {
            if (!o1IsEmpty) return -1;
            if (!o2IsEmpty) return 1;

            return 0;
        }
        if (o1.getLayerId().isPresent() != o2.getLayerId().isPresent()) {
            return o1.getLayerId().isPresent() ? 1 : -1;
        }

        return Cf.Long.cmp(o1.getLayerId().orElse(o1.getResourceId()).get(),
                o2.getLayerId().orElse(o2.getResourceId()).get());
    }

} //~
