package ru.yandex.calendar.logic.event;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class EventInterval {
    private final Instant instanceStart;
    private final EventDateTime start;
    private final EventDateTime end;

    public EventInterval(Instant instanceStart, EventDateTime start, EventDateTime end) {
        Validate.equals(start.isDate(), end.isDate());
        this.instanceStart = instanceStart;
        this.start = start;
        this.end = end;
    }

    public Instant getInstanceStart() {
        return instanceStart;
    }

    public EventDateTime getStart() {
        return start;
    }

    public EventDateTime getEnd() {
        return end;
    }

    public InstantInterval toInstantInterval(DateTimeZone tz) {
        return new InstantInterval(start.toInstant(tz), end.toInstant(tz));
    }
}
