package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.beans.generated.EventInvitationFields;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class EventInvitationId {
    private final long eventId;
    private final Email email;

    @FillWithSomething
    public EventInvitationId(long eventId, Email email) {
        this.eventId = eventId;
        this.email = email;
    }

    public static EventInvitationId of(EventInvitation i) {
        return new EventInvitationId(i.getEventId(), i.getEmail());
    }

    public Tuple2<Long, Email> asTuple() {
        return Tuple2.tuple(eventId, email);
    }

    public static ListF<MapField<?>> fields() {
        return Cf.list(EventInvitationFields.EVENT_ID, EventInvitationFields.EMAIL);
    }

    public static SqlCondition inSet(CollectionF<EventInvitationId> ids) {
        return BeanHelper.fieldsInSetCondition(fields(), ids.map(EventInvitationId::asTuple));
    }

    public SqlCondition eq() {
        return inSet(Cf.set(this));
    }

    public long getEventId() {
        return eventId;
    }

    public Email getEmail() {
        return email;
    }
}
