package ru.yandex.calendar.logic.event;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.resource.ResourceRoutines;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.participant.ParticipantData;
import ru.yandex.inside.passport.blackbox.PassportDomain;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class EventInvitationRoutines {
    @Autowired
    private EventInvitationDao eventInvitationDao;

    private static final EventInvitation EVENT_INVITATION_DEFAULTS = new EventInvitation();
    static {
        EVENT_INVITATION_DEFAULTS.setName("");
        EVENT_INVITATION_DEFAULTS.setPrivateTokenNull();

        EVENT_INVITATION_DEFAULTS.setDecision(Decision.UNDECIDED);
        EVENT_INVITATION_DEFAULTS.setIsOrganizer(false);
        EVENT_INVITATION_DEFAULTS.setReasonNull();

        EVENT_INVITATION_DEFAULTS.setSequence(0);
        EVENT_INVITATION_DEFAULTS.setDtstampNull();

        EVENT_INVITATION_DEFAULTS.setCreationSource(ActionSource.UNKNOWN);
        EVENT_INVITATION_DEFAULTS.setModificationSource(ActionSource.UNKNOWN);
        EVENT_INVITATION_DEFAULTS.setCreationReqIdNull();
        EVENT_INVITATION_DEFAULTS.setModificationReqIdNull();
    }

    public EventInvitation createEventInvitationData(
            ActorId sender, long eventId, ParticipantData participantData,
            Decision decision, String privateToken, ActionInfo actionInfo)
    {
        EventInvitation invitation = participantData.toInvitation();
        invitation.setDecision(decision);
        invitation.setEventId(eventId);
        invitation.setPrivateToken(privateToken);
        // XXX: upyachka, make field optional
        invitation.setCreatorUid(sender.isUser()
                ? sender.getUid() : ResourceRoutines.getMasterOfResources(PassportDomain.YANDEX_TEAM_RU));
        invitation.setCreationReqId(actionInfo.getRequestIdWithHostId());
        invitation.setCreationTs(actionInfo.getNow());

        return invitation;
    }

    public EventInvitation createEventInvitation(
            UidOrResourceId sender, long eventId, ParticipantData participantData,
            Decision decision, String privateToken, ActionInfo actionInfo)
    {
        EventInvitation invitation = createEventInvitationData(
                ActorId.userOrResource(sender), eventId, participantData, decision, privateToken, actionInfo);

        eventInvitationDao.saveEventInvitation(invitation, actionInfo);

        invitation.setFieldDefaults(EVENT_INVITATION_DEFAULTS);

        return invitation;
    }

    public Option<EventInvitation> findEventInvitation(long eventId, Email email) {
        return eventInvitationDao.findEventInvitationByEventIdAndEmail(eventId, email);
    }
}
