package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.beans.generated.EventLayerFields;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
public class EventLayerId {
    private final long eventId;
    private final long layerId;

    @FillWithSomething
    public EventLayerId(long eventId, long layerId) {
        this.eventId = eventId;
        this.layerId = layerId;
    }

    public static EventLayerId of(EventLayer el) {
        return new EventLayerId(el.getEventId(), el.getLayerId());
    }

    public Tuple2<Long, Long> asTuple() {
        return Tuple2.tuple(eventId, layerId);
    }

    public static ListF<MapField<?>> fields() {
        return Cf.list(EventLayerFields.EVENT_ID, EventLayerFields.LAYER_ID);
    }

    public static SqlCondition inSet(CollectionF<EventLayerId> ids) {
        return BeanHelper.fieldsInSetCondition(fields(), ids.map(EventLayerId::asTuple));
    }

    public SqlCondition eq() {
        return inSet(Cf.set(this));
    }

    public long getEventId() {
        return eventId;
    }

    public long getLayerId() {
        return layerId;
    }
}
