package ru.yandex.calendar.logic.event;

import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public class EventLayerWithRelations {
    private final EventLayer eventLayer;
    private final Layer layer;

    public EventLayerWithRelations(EventLayer eventLayer, Layer layer) {
        Validate.equals(eventLayer.getLayerId(), layer.getId().longValue());

        this.eventLayer = eventLayer;
        this.layer = layer;
    }

    public PassportUid getLayerCreatorUid() {
        return layer.getCreatorUid();
    }

    public boolean layerCreatorUidIs(PassportUid uid) {
        return getLayerCreatorUid().sameAs(uid);
    }

    public Layer getLayer() {
        return layer;
    }

    public EventLayer getEventLayer() {
        return eventLayer;
    }

    public long getLayerId() {
        return eventLayer.getLayerId();
    }

    public long getEventId() {
        return eventLayer.getEventId();
    }

} //~
