package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.inside.passport.PassportUid;

public class EventLayers {
    private final ListF<EventLayerWithRelations> layers;

    public EventLayers(ListF<EventLayerWithRelations> layers) {
        this.layers = layers;
    }

    public ListF<EventLayerWithRelations> getLayersWithRelations() {
        return layers;
    }

    public ListF<Layer> getLayers() {
        return layers.map(EventLayerWithRelations::getLayer);
    }

    public ListF<EventLayer> getEventLayers() {
        return layers.map(EventLayerWithRelations::getEventLayer);
    }

    public ListF<Long> getLayerIds() {
        return layers.map(EventLayerWithRelations::getLayerId);
    }

    public Option<EventLayerWithRelations> findLayerWithRelationsById(long layerId) {
        return layersById().getO(layerId);
    }

    public Option<EventLayerWithRelations> findLayerWithRelationsByUid(PassportUid uid) {
        return layersByUid().getO(uid);
    }

    public boolean isEmpty() {
        return layers.isEmpty();
    }

    private transient MapF<PassportUid, EventLayerWithRelations> layerByUid;

    private MapF<PassportUid, EventLayerWithRelations> layersByUid() {
        if (layerByUid == null) {
            layerByUid = layers.toMapMappingToKey(EventLayerWithRelations::getLayerCreatorUid);
        }
        return layerByUid;
    }

    private transient MapF<Long, EventLayerWithRelations> layerById;

    private MapF<Long, EventLayerWithRelations> layersById() {
        if (layerById == null) {
            layerById = layers.toMapMappingToKey(EventLayerWithRelations::getLayerId);
        }
        return layerById;
    }
}
