package ru.yandex.calendar.logic.event;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.Bean;
import ru.yandex.calendar.util.db.CalendarJdbcTemplate;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 *
 * @param T Event or Layer
 * @param U EventLayer or LayerUser
 */
public abstract class EventOrLayerRoutines<T extends Bean, U extends Bean> {

    @Autowired
    private CalendarJdbcTemplate jdbcTemplate;

    /** @deprecated */
    @Deprecated
    protected CalendarJdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    /**
     * Tries to find owner bean, namely:
     *  <b>layer user</b> for this user (for layer), or
     *  <b>event layer</b> at one of user's layers / resource (for event),
     * no matter if target is created or shared by the user
     */
    protected abstract Option<U> findOwnerBean(PassportUid uid, long id);

    /** checks whether given target is shared by given user / resource (i.e. there is a bean created by someone else) */
    public final boolean isShared(PassportUid uid, long id) {
        // XXX: why it returns true for resource and ext user? // stepancheg@
        return findOwnerBean(uid, id).isPresent() && !uid.sameAs(getCreatorUid(id));
    }

    public abstract PassportUid getCreatorUid(long layerId);

} //~
