package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.EventResource;
import ru.yandex.calendar.logic.beans.generated.EventResourceFields;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
public class EventResourceId {
    private final long eventId;
    private final long resourceId;

    @FillWithSomething
    public EventResourceId(long eventId, long resourceId) {
        this.eventId = eventId;
        this.resourceId = resourceId;
    }

    public static EventResourceId of(EventResource el) {
        return new EventResourceId(el.getEventId(), el.getResourceId());
    }

    public Tuple2<Long, Long> asTuple() {
        return Tuple2.tuple(eventId, resourceId);
    }

    public static ListF<MapField<?>> fields() {
        return Cf.list(EventResourceFields.EVENT_ID, EventResourceFields.RESOURCE_ID);
    }

    public static SqlCondition inSet(CollectionF<EventResourceId> ids) {
        return BeanHelper.fieldsInSetCondition(fields(), ids.map(EventResourceId::asTuple));
    }

    public SqlCondition eq() {
        return inSet(Cf.set(this));
    }

    public long getEventId() {
        return eventId;
    }

    public long getResourceId() {
        return resourceId;
    }
}
