package ru.yandex.calendar.logic.event;

import org.joda.time.Instant;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;

/**
 * This class stores data, which are used to synchronize event instance from ics, exchange
 * with event instance from db store.
 * @author akirakozov
 */
public abstract class EventSynchData extends DefaultObject {
    // sequence could be null by iCal specification,
    // we suppose, that sequence == null <=> sequence == 0
    public final int sequence;
    public final Instant lastModified;
    public final Instant dtstamp;

    protected EventSynchData(int sequence, Instant lastModified, Instant dtstamp) {
        Validate.notNull(lastModified);
        Validate.notNull(dtstamp);

        this.sequence = sequence;
        this.lastModified = lastModified;
        this.dtstamp = dtstamp;
    }

    public SequenceAndDtStamp getSequenceAndDtstamp() {
        return new SequenceAndDtStamp(sequence, dtstamp);
    }
}
