package ru.yandex.calendar.logic.event;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class EventTime {

    private final Instant startTs;
    private final Instant endTs;
    private final boolean isAllDay;
    private final DateTimeZone tz;

    public EventTime(Instant startTs, Instant endTs, boolean isAllDay, String tzId) {
        this(startTs, endTs, isAllDay, AuxDateTime.getVerifyDateTimeZone(tzId));
    }

    public EventTime(Instant startTs, Instant endTs, boolean isAllDay, DateTimeZone tz) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.isAllDay = isAllDay;
        this.tz = tz;
    }

    public DateTime getStart() {
        return getEventDateTime(startTs).toDateTime(tz);
    }

    public Instant getStartTs() {
        return getEventDateTime(startTs).toInstant(tz);
    }

    public DateTime getEnd() {
        return getEventDateTime(endTs).toDateTime(tz);
    }

    public Instant getEndTs() {
        return getEventDateTime(endTs).toInstant(tz);
    }

    public boolean isAllDay() {
        return isAllDay;
    }

    public DateTimeZone getTz() {
        return tz;
    }

    public EventInterval getEventInterval(InstantInterval interval) {
        return new EventInterval(
                interval.getStart(),
                getEventDateTime(interval.getStart()),
                getEventDateTime(interval.getEnd()));
    }

    public EventDateTime getEventDateTime(Instant startOrEnd) {
        return isAllDay
                ? EventDateTime.date(new LocalDate(startOrEnd, tz))
                : EventDateTime.dateTime(startOrEnd);
    }
}
