package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.SettingsYt;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.user.SettingsInfo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.Validate;

public class EventUserWithRelations {
    private final EventUser eventUser;
    private final SettingsInfo settings;

    public EventUserWithRelations(EventUser eventUser, SettingsInfo settings) {
        Validate.V.equals(eventUser.getUid(), settings.getUid());

        this.eventUser = eventUser;
        this.settings = settings;
    }

    public long getId() {
        return eventUser.getId();
    }

    public PassportUid getUid() {
        return eventUser.getUid();
    }

    public long getEventId() {
        return eventUser.getEventId();
    }

    public EventUser getEventUser() {
        return eventUser;
    }

    public SettingsInfo getSettings() {
        return settings;
    }

    public Option<SettingsYt> getSettingsYt() {
        return settings.getYt();
    }

    public boolean isAttendeeOrOrganizerOrSubscriber() {
        return eventUser.getIsAttendee() || eventUser.getIsOrganizer() || eventUser.getIsSubscriber();
    }

    public boolean isAttendee() {
        return eventUser.getIsAttendee();
    }

    public boolean isOrganizer() {
        return eventUser.getIsOrganizer();
    }

    public Decision getDecision() {
        return eventUser.getDecision();
    }
} //~
