package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.lang.Validate;

/**
 * @author dbrylev
 */
public class EventsAttachedLayerIds {
    private final Tuple2List<Event, EventAttachedLayerId> events;

    public EventsAttachedLayerIds(Tuple2List<Event, EventAttachedLayerId> events) {
        ListF<Event> eventsEvents = events.get1();
        Validate.isTrue(eventsEvents.map(Event.getMainEventIdF()).unique().size() < 2);
        Validate.unique(eventsEvents.map(Event.getIdF()));

        this.events = events;
    }

    public static EventsAttachedLayerIds empty() {
        return new EventsAttachedLayerIds(Tuple2List.<Event, EventAttachedLayerId>tuple2List());
    }

    public Option<EventAttachedLayerId> findMasterEvent() {
        return events.findBy1(Event.getRecurrenceIdF().andThen(Cf2.f1B(us -> !us.isPresent())))
                .map(Tuple2.<Event, EventAttachedLayerId>get2F());
    }

    public Option<EventAttachedLayerId> findByEventId(long eventId) {
        return events.findBy1(Event.getIdF().andThenEquals(eventId))
                .map(Tuple2.<Event, EventAttachedLayerId>get2F());
    }

    public ListF<Long> getAllLayerIds() {
        return events.get2().flatMap(EventAttachedLayerId.getAllLayerIdsF()).stableUnique();
    }

    public Tuple2List<Event, EventAttachedLayerId> getEvents() {
        return events;
    }
}
