package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.event.model.EventUserUpdate;
import ru.yandex.calendar.logic.log.change.changes.EventFieldsChangesJson;
import ru.yandex.inside.passport.PassportUid;

public class EventsAttachedUser {
    public final ListF<EventAttachedUser> events;
    public final Option<PassportUid> uid;

    public EventsAttachedUser(ListF<EventAttachedUser> events, Option<PassportUid> uid) {
        this.events = events;
        this.uid = uid;
    }

    public static EventsAttachedUser empty() {
        return new EventsAttachedUser(Cf.list(), Option.empty());
    }

    public static EventsAttachedUser detached(
            PassportUid uid, ListF<Event> events, ListF<EventUserUpdate> eventUsers, ListF<EventLayer> eventLayers)
    {
        MapF<Long, EventUserUpdate> eventUserByEventId = eventUsers
                .toMapMappingToKey(eu -> eu.cur.orElse(eu.old).get().getEventId());

        MapF<Long, EventLayer> eventLayerByEventId = eventLayers.toMapMappingToKey(EventLayer::getEventId);

        return new EventsAttachedUser(events.map(e -> new EventAttachedUser(e, EventFieldsChangesJson.empty(),
                eventUserByEventId.getO(e.getId()).getOrElse(EventUserUpdate::empty),
                eventLayerByEventId.getO(e.getId()).map(el -> EventAttachedLayerId.detached(el.getLayerId())))),
                Option.of(uid));
    }

    public EventsAttachedLayerIds getLayers() {
        return new EventsAttachedLayerIds(Tuple2List.tuple2List(
                events.filterMap(event -> event.layerId.map(layerId -> Tuple2.tuple(event.event, layerId)))));
    }
}
