package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Option;

/**
 * @author dbrylev
 */
public class EventsFilter {
    private final Option<Long> noPermsCheckLayerId;
    private final boolean includeDeclined;
    private final boolean opaqueOnly;
    private final boolean mergeLayers;

    public static final EventsFilter DEFAULT = new EventsFilter(Option.empty(), false, false, false);

    public EventsFilter(
            Option<Long> noPermsCheckLayerId, boolean includeDeclined, boolean opaqueOnly, boolean mergeLayers)
    {
        this.noPermsCheckLayerId = noPermsCheckLayerId;
        this.includeDeclined = includeDeclined;
        this.opaqueOnly = opaqueOnly;
        this.mergeLayers = mergeLayers;
    }

    public Option<Long> getNoPermsCheckLayerId() {
        return noPermsCheckLayerId;
    }

    public boolean includeDeclined() {
        return includeDeclined;
    }

    public boolean opaqueOnly() {
        return opaqueOnly;
    }

    public boolean mergeLayers() {
        return mergeLayers;
    }
}
