package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.lang.Validate;

/**
 * @author gutman
 */

// XXX: this is temporary
// this will become ExternalIdOrFileName ADT when external_id_normalized column is filled
// for now we will search by any field
public class ExternalId {

    private final String raw;
    private final String normalized;

    @FillWithSomething
    public ExternalId(String raw) {
        Validate.V.notEmpty(raw);

        this.raw = raw;
        this.normalized = raw.replaceAll("[^a-zA-Z0-9]", "");
    }

    public String getRaw() {
        return raw;
    }

    public String getNormalized() {
        return normalized;
    }

    public static Function<ExternalId, String> getRawF() {
        return new Function<ExternalId, String>() {
            public String apply(ExternalId externalId) {
                return externalId.getRaw();
            }
        };
    }

    public static Function<ExternalId, String> getNormalizedF() {
        return new Function<ExternalId, String>() {
            public String apply(ExternalId externalId) {
                return externalId.getNormalized();
            }
        };
    }

    public static Function<String, ExternalId> consF() {
        return new Function<String, ExternalId>() {
            public ExternalId apply(String s) {
                return new ExternalId(s);
            }
        };
    }

}
