package ru.yandex.calendar.logic.event;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.Validate;

/**
 * XXX rename (Uid..., ExternalId... or VEvent...)
 * @author ssytnik
 */
public class IcsEventSynchData extends EventSynchData {
    public final Option<String> externalId;
    public final Option<Instant> recurrenceId;

    public IcsEventSynchData(Option<String> externalId, Option<Instant> recurrenceId, int sequence, Instant lastModified, Instant dtstamp) {
        super(sequence, lastModified, dtstamp);

        Validate.notNull(recurrenceId);

        this.externalId = externalId;
        this.recurrenceId = recurrenceId;
    }
}
