package ru.yandex.calendar.logic.event;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author dbrylev
 */
public class InaccessibleResourcesRequest {

    private final ListF<ResourceInfo> resources;
    private final RepetitionInstanceInfo repetitionInfo;
    private final Option<Instant> nowO;
    private final ListF<PassportUid> users;
    private final Option<Long> excludeEventId;
    private final boolean isVerify;

    private InaccessibleResourcesRequest(
            ListF<ResourceInfo> resources, RepetitionInstanceInfo repetitionInfo,
            Option<Instant> nowO, ListF<PassportUid> users,
            Option<Long> excludeEventId, boolean isVerify)
    {
        this.resources = resources;
        this.repetitionInfo = repetitionInfo;
        this.nowO = nowO;
        this.users = users;
        this.excludeEventId = excludeEventId;
        this.isVerify = isVerify;
    }

    public static InaccessibleResourcesRequest noEventsLookupAndDistance(
            ListF<ResourceInfo> resources, RepetitionInstanceInfo repetitionInfo)
    {
        return new InaccessibleResourcesRequest(
                resources, repetitionInfo, Option.empty(), Cf.list(), Option.empty(), false);
    }

    public static InaccessibleResourcesRequest noEventsLookup(
            ListF<ResourceInfo> resources, RepetitionInstanceInfo repetitionInfo, Instant now)
    {
        return new InaccessibleResourcesRequest(
                resources, repetitionInfo, Option.of(now), Cf.list(), Option.empty(), false);
    }

    public static InaccessibleResourcesRequest verify(
            ListF<ResourceInfo> resources, ListF<PassportUid> users,
            RepetitionInstanceInfo repetitionInfo, Option<Long> excludeEventId, Instant now)
    {
        return new InaccessibleResourcesRequest(
                resources, repetitionInfo, Option.of(now), users, excludeEventId, true);
    }

    public ListF<PassportUid> getUsers() {
        return users;
    }

    public Option<Long> getExcludeEventId() {
        return excludeEventId;
    }

    public ListF<ResourceInfo> getResources() {
        return resources;
    }

    public RepetitionInstanceInfo getRepetitionInfo() {
        return repetitionInfo;
    }

    public Option<Instant> getNowO() {
        return nowO;
    }

    public boolean isVerify() {
        return isVerify;
    }
}
