package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.misc.time.InstantInterval;

/**
 * Event interval comparator (start ascending, then end descending)
 * @author ssytnik
 */
public class IntervalComparator implements Comparator<InstantInterval> {
    public static final IntervalComparator INSTANCE = new IntervalComparator();

    private IntervalComparator() {}

    public int compare(InstantInterval i1, InstantInterval i2) { // e.start_ts, e.end_ts DESC
        int iStart = i1.getStart().compareTo(i2.getStart());
        if (iStart != 0) { return iStart; }
        return -i1.getEnd().compareTo(i2.getEnd());
    }
}
