package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.function.Function1B;

/**
 * @author dbrylev
 */
public class LayerIdChangesInfo {
    private final SetF<Long> addedLayerIds;
    private final SetF<Long> unchangedLayerIds;
    private final SetF<Long> removedLayerIds;

    public LayerIdChangesInfo(SetF<Long> addedLayerIds, SetF<Long> unchangedLayerIds, SetF<Long> removedLayerIds) {
        this.addedLayerIds = addedLayerIds;
        this.unchangedLayerIds = unchangedLayerIds;
        this.removedLayerIds = removedLayerIds;
    }

    public static LayerIdChangesInfo changes(
            CollectionF<Long> previous, CollectionF<Long> added, CollectionF<Long> removed)
    {
        return changes(previous, previous.unique().plus(added).minus(removed));
    }

    public static LayerIdChangesInfo changes(CollectionF<Long> previous, CollectionF<Long> current) {
        SetF<Long> previousSet = previous.unique();
        SetF<Long> currentSet = current.unique();

        return new LayerIdChangesInfo(
                currentSet.minus(previousSet), currentSet.intersect(previousSet), previousSet.minus(currentSet));
    }

    public static LayerIdChangesInfo unchanged(CollectionF<Long> layerIds) {
        return new LayerIdChangesInfo(Cf.<Long>set(), layerIds.unique(), Cf.<Long>set());
    }

    public static LayerIdChangesInfo removed(CollectionF<Long> layerIds) {
        return new LayerIdChangesInfo(Cf.<Long>set(), Cf.<Long>set(), layerIds.unique());
    }

    public LayerIdChangesInfo removedOnly() {
        return new LayerIdChangesInfo(Cf.<Long>set(), Cf.<Long>set(), removedLayerIds);
    }

    public LayerIdChangesInfo withoutRemoved() {
        return new LayerIdChangesInfo(addedLayerIds, unchangedLayerIds, Cf.<Long>set());
    }

    public LayerIdChangesInfo filterOut(CollectionF<Long> ids) {
        Function1B<Long> filterF = ids.unique().containsF().notF();
        return new LayerIdChangesInfo(
                addedLayerIds.filter(filterF), unchangedLayerIds.filter(filterF), removedLayerIds.filter(filterF));
    }

    public ListF<Long> getAll() {
        return addedLayerIds.plus(removedLayerIds).plus(unchangedLayerIds).toList();
    }

    public SetF<Long> getAddedAndRemoved() {
        return addedLayerIds.plus(removedLayerIds);
    }

    public SetF<Long> getAdded() {
        return addedLayerIds;
    }

    public SetF<Long> getUnchanged() {
        return unchangedLayerIds;
    }

    public SetF<Long> getRemoved() {
        return removedLayerIds;
    }
}
