package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 */
public class LayerIdPredicate {
    /**
     * Specifies whether only layers visible in this user's UI will
     * be taken into attention when selecting events.
     */
    private final boolean onlyVisibleInUi;

    private LayerIdPredicate(boolean onlyVisibleInUi) {
        this.onlyVisibleInUi = onlyVisibleInUi;
    }

    public boolean isOnlyVisibleInUi() {
        return onlyVisibleInUi;
    }

    public ListF<Long> getIds() {
        throw new IllegalStateException();
    }

    public ListF<PassportUid> getUids() {
        throw new IllegalStateException();
    }

    private static class AllForUsers extends LayerIdPredicate {
        private final ListF<PassportUid> uids;

        public AllForUsers(ListF<PassportUid> uids, boolean onlyVisibleInUi) {
            super(onlyVisibleInUi);
            this.uids = uids;
        }

        @Override
        public ListF<PassportUid> getUids() {
            return uids;
        }
    }

    private static class IdList extends LayerIdPredicate {
        private final ListF<Long> ids;

        public IdList(ListF<Long> uids, boolean onlyVisibleInUi) {
            super(onlyVisibleInUi);
            this.ids = uids;
        }

        @Override
        public ListF<Long> getIds() {
            return ids;
        }
    }

    public boolean isList() {
        return this instanceof IdList;
    }

    public boolean isAllForUsers() {
        return this instanceof AllForUsers;
    }

    public static LayerIdPredicate allForUsers(ListF<PassportUid> uids, boolean onlyVisibleInUi) {
        return new AllForUsers(uids, onlyVisibleInUi);
    }

    public static LayerIdPredicate allForUser(PassportUid uid, boolean onlyVisibleInUi) {
        return new AllForUsers(Cf.list(uid), onlyVisibleInUi);
    }

    public static LayerIdPredicate list(ListF<Long> ids, boolean onlyVisibleInUi) {
        return new IdList(ids, onlyVisibleInUi);
    }

} //~
