package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.ListF;

/**
 * @author Daniel Brylev
 */
public class LayerIdsOrResourceIds {
    private final ListF<Long> ids;
    private final boolean isLayers;


    public LayerIdsOrResourceIds(ListF<Long> ids, boolean isLayers) {
        this.ids = ids;
        this.isLayers = isLayers;
    }

    public boolean isLayers() {
        return isLayers;
    }

    public boolean isResources() {
        return !isLayers();
    }

    public ListF<Long> get() {
        return ids;
    }

    public static LayerIdsOrResourceIds layerIds(ListF<Long> ids) {
        return new LayerIdsOrResourceIds(ids, true);
    }

    public static LayerIdsOrResourceIds resourceIds(ListF<Long> ids) {
        return new LayerIdsOrResourceIds(ids, false);
    }
}
