package ru.yandex.calendar.logic.event;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.MainEvent;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.sharing.participant.ResourceParticipantInfo;

/**
 * @author Daniel Brylev
 */
public class MainEventInfo {
    private final MainEvent mainEvent;
    private final ListF<EventInfo> eventInfos;

    public MainEventInfo(MainEvent mainEvent, ListF<EventInfo> eventInfos) {
        this.mainEvent = mainEvent;
        this.eventInfos = eventInfos;
    }

    public ListF<EventInfo> getMasterEventInfos() {
        return getEventInfos().filterNot(e -> e.getRecurrenceId().isPresent());
    }

    public ListF<EventInfo> getRecurrenceEventInfos() {
        return getEventInfos().filter(e -> e.getRecurrenceId().isPresent());
    }

    public long getMainEventId() {
        return mainEvent.getId();
    }

    public MainEvent getMainEvent() {
        return mainEvent;
    }

    public Instant getMainEventLastUpdateTs() {
        return mainEvent.getLastUpdateTs();
    }

    public ListF<EventInfo> getEventInfos() {
        return eventInfos;
    }

    public ListF<Long> getEventIds() {
        return eventInfos.map(EventInfo::getEventId);
    }

    public ListF<EventWithRelations> getEventsWithRelations() {
        return getEventInfos().map(EventInfo::getEventWithRelations);
    }

    public ListF<EventWithRelations> getMasterEventsWithRelations() {
        return getMasterEventInfos().map(EventInfo::getEventWithRelations);
    }

    public ListF<EventWithRelations> getRecurrenceEventsWithRelations() {
        return getRecurrenceEventInfos().map(EventInfo::getEventWithRelations);
    }

    public ListF<ResourceParticipantInfo> findResourceParticipation(long resourceId) {
        return getEventInfos().filterMap(ei -> ei.findResourceParticipant(resourceId));
    }

    public ListF<Long> findResourcesIdsAsyncWithExchange() {
        return getEventsWithRelations()
                .flatMap(EventWithRelations::getResources)
                .filter(ResourceInfo.isAsyncWithExchangeF())
                .map(ResourceInfo.resourceIdF()).stableUnique();
    }
}
