package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.MainEvent;

/**
 * @author Stepan Koltsov
 */
public class MainEventWithRelations {
    private final MainEvent mainEvent;
    private final ListF<EventWithRelations> events;

    public MainEventWithRelations(MainEvent mainEvent, ListF<EventWithRelations> events) {
        this.mainEvent = mainEvent;
        this.events = events;
    }

    public MainEvent getMainEvent() {
        return mainEvent;
    }

    public ListF<EventWithRelations> getEventsWithRelations() {
        return events;
    }

    public ListF<Event> getEvents() {
        return events.map(EventWithRelations::getEvent);
    }

    public boolean isOrphaned() {
        return events.isEmpty();
    }

    public ListF<EventWithRelations> getMasterEvents() {
        return getEventsWithRelations().filter(e -> !e.getRecurrenceId().isPresent());
    }

    public ListF<EventWithRelations> getRecurrenceEvents() {
        return getEventsWithRelations().filter(e -> e.getRecurrenceId().isPresent());
    }
} //~
