package ru.yandex.calendar.logic.event;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventFields;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author Stepan Koltsov
 */
public class RecurrenceIdOrMainEvent {
    private final Option<Instant> recurrenceId;

    public RecurrenceIdOrMainEvent(Option<Instant> recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public Option<Instant> getRecurrenceId() {
        return recurrenceId;
    }

    public static RecurrenceIdOrMainEvent recurrenceId(Instant recurrenceId) {
        return new RecurrenceIdOrMainEvent(Option.of(recurrenceId));
    }

    public static RecurrenceIdOrMainEvent mainEvent() {
        return new RecurrenceIdOrMainEvent(Option.<Instant>empty());
    }

    public SqlCondition toSqlCondition() {
        if (recurrenceId.isPresent()) {
            return EventFields.RECURRENCE_ID.eq(recurrenceId.get());
        } else {
            return EventFields.RECURRENCE_ID.column().isNull();
        }
    }

} //~
