package ru.yandex.calendar.logic.event;

import org.joda.time.Instant;

import ru.yandex.calendar.logic.beans.generated.Event;

/**
 * @author ssytnik
 */
public class SequenceAndDtStamp {
    private int sequence;
    private Instant dtStamp;

    public SequenceAndDtStamp(int sequence, Instant dtStamp) {
        this.sequence = sequence;
        this.dtStamp = dtStamp;
    }

    // TODO ssytnik: ensure that invoking methods properly choose event (old or new one)
    public static SequenceAndDtStamp web(Event event, ActionInfo actionInfo) {
        return new SequenceAndDtStamp(event.getSequence(), actionInfo.getNow());
    }

    public static SequenceAndDtStamp fromSynchData(EventSynchData data) {
        return new SequenceAndDtStamp(data.sequence, data.dtstamp);
    }


    public int getSequence() {
        return sequence;
    }

    public Instant getDtStamp() {
        return dtStamp;
    }
}
