package ru.yandex.calendar.logic.event;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.sending.EventSendingInfo;
import ru.yandex.calendar.logic.sending.param.EventOnLayerChangeMessageParameters;

/**
 * @author dbrylev
 */
public class UpdateInfo {
    private final ListF<Long> affectedLayerIds;
    private final ListF<EventSendingInfo> sendingInfos;
    private final ListF<EventOnLayerChangeMessageParameters> layerNotifyMails;

    public UpdateInfo(
            ListF<Long> affectedLayerIds,
            ListF<EventSendingInfo> sendingInfos,
            ListF<EventOnLayerChangeMessageParameters> layerNotifyMails)
    {
        this.affectedLayerIds = affectedLayerIds;
        this.sendingInfos = sendingInfos;
        this.layerNotifyMails = layerNotifyMails;
    }

    public UpdateInfo plusAffectedLayerIds(ListF<Long> ids) {
        return new UpdateInfo(affectedLayerIds.plus(ids), sendingInfos, layerNotifyMails);
    }

    public ListF<Long> getAffectedLayerIds() {
        return affectedLayerIds;
    }

    public ListF<EventSendingInfo> getSendingInfos() {
        return sendingInfos;
    }

    public ListF<EventOnLayerChangeMessageParameters> getLayerNotifyMails() {
        return layerNotifyMails;
    }
}
