package ru.yandex.calendar.logic.event;

import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.webNew.dto.in.WebEventData;
import ru.yandex.calendar.frontend.webNew.dto.inOut.EventAttachmentData;
import ru.yandex.calendar.logic.beans.generated.Repetition;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.event.model.EventInvitationData;
import ru.yandex.calendar.logic.event.model.EventInvitationUpdateData;
import ru.yandex.calendar.logic.event.model.EventInvitationsData;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class WebNewEventDataConverter extends AbstractEventDataConverter {

    private final WebEventData webEventData;
    private final DateTimeZone dataTz;

    private WebNewEventDataConverter(WebEventData webEventData, DateTimeZone dataTz, DateTimeZone eventTz) {
        super(eventTz);
        this.dataTz = dataTz;
        this.webEventData = webEventData;
    }

    @Override
    protected EventData doConvert() {
        EventData eventData = new EventData();
        eventData.setEvent(webEventData.getEvent(dataTz, eventTz));
        eventData.setTimeZone(eventTz);

        eventData.setEventUserData(webEventData.getEventUserData());

        Option<ListF<Email>> requiredEmails = webEventData.getAttendeeEmails();
        Option<ListF<Email>> optionalEmails = webEventData.getOptionalAttendeeEmails();

        if (requiredEmails.isPresent() || optionalEmails.isPresent()) {
            ListF<EventInvitationData> requiredInvitations = requiredEmails.orElse(Cf.list())
                    .map(email -> new EventInvitationData(email, false));
            ListF<EventInvitationData> optionalInvitations = optionalEmails.orElse(Cf.list())
                    .map(email -> new EventInvitationData(email, true));

            ListF<EventInvitationData> allInvitations = requiredInvitations.plus(optionalInvitations);

            eventData.setInvData(new EventInvitationsData(
                    webEventData.getOrganizerEmail(), allInvitations));
        } else {
            eventData.setInvData(new EventInvitationUpdateData(
                    webEventData.getOrganizerEmail(), Cf.list(), Cf.list()));
        }

        if (webEventData.getLayerId().isPresent()) {
            eventData.setLayerId(webEventData.getLayerId().get());
        }

        Option<Repetition> repetition = webEventData.getRepetition(dataTz, eventTz);
        if (repetition.isPresent()) {
            eventData.setRepetition(repetition.get());
        }

        ListF<EventAttachmentData> attachments = webEventData.getAttachments().orElse(Cf.list());
        eventData.setAttachments(attachments.map(EventAttachmentData::toEventAttachment));

        return eventData;
    }

    public static EventData convert(WebEventData eventData, DateTimeZone dataTz, DateTimeZone eventTz) {
        return new WebNewEventDataConverter(eventData, dataTz, eventTz).convert();
    }
}
