package ru.yandex.calendar.logic.event.archive;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.Bean;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.commune.mapObject.MapObjectDescription;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 */
public class MapObjectCopier<A extends Bean, B extends Bean> {

    private final Tuple2List<MapField<?>, MapField<?>> copyFields;

    public MapObjectCopier(Class<A> a, Class<B> b) {
        this(ClassX.wrap(a), ClassX.wrap(b));
    }

    public MapObjectCopier(ClassX<A> a, ClassX<B> b) {
        final MapObjectDescription aFields = BeanHelper.forBean(a).beanMapObjectDescription();
        final MapObjectDescription bFields = BeanHelper.forBean(b).beanMapObjectDescription();
        ListF<String> aNames = aFields.getFields().map(MapField::getName);
        ListF<String> bNames = bFields.getFields().map(MapField::getName);
        SetF<String> commonNames = aNames.unique().intersect(bNames.unique());

        copyFields = Cf.Tuple2List.cons(commonNames.map(new Function<String, Tuple2<MapField<?>, MapField<?>>>() {
            public Tuple2<MapField<?>, MapField<?>> apply(String name) {
                MapField<?> aField = aFields.getFieldByName(name);
                MapField<?> bField = bFields.getFieldByName(name);
                return Tuple2.tuple(aField, bField).uncheckedCast();
            }
        }));
    }

    public boolean isNotEmpty() {
        return copyFields.isNotEmpty();
    }

    public void copy(A src, B dst) {
        for (Tuple2<MapField<?>, MapField<?>> fields : copyFields) {
            MapField<?> aField = fields._1;
            MapField<?> bField = fields._2;
            Object value = src.getFieldValue(aField);
            dst.setFieldValue(bField.<Object>cast(), value);
        }
    }

} //~
