package ru.yandex.calendar.logic.event.attachment;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.calendar.logic.beans.generated.EventAttachment;

/**
 * @author Daniel Brylev
 */
public class EventAttachmentChangesFinder {

    public static EventAttachmentChangesInfo changes(
            ListF<EventAttachment> oldAttachments, ListF<EventAttachment> newAttachments)
    {
        SetF<String> oldAttachmentUrls = oldAttachments.map(EventAttachment.getUrlF()).unique();
        SetF<String> newAttachmentUrls = newAttachments.map(EventAttachment.getUrlF()).unique();

        ListF<String> deleteAttachmentUrls = oldAttachments
                .filter(EventAttachment.getUrlF().andThen(newAttachmentUrls.containsF().notF()))
                .map(EventAttachment.getUrlF());
        ListF<EventAttachment> createAttachments = newAttachments
                .filter(EventAttachment.getUrlF().andThen(oldAttachmentUrls.containsF().notF()));

        return new EventAttachmentChangesInfo(deleteAttachmentUrls, createAttachments);
    }
}
