package ru.yandex.calendar.logic.event.attachment;

import java.util.List;

import lombok.Value;

import ru.yandex.calendar.logic.beans.generated.EventAttachment;

import static java.util.Collections.emptyList;

@Value
public class EventAttachmentChangesInfo {
    List<String> removeAttachmentUrls;
    List<EventAttachment> newAttachments;

    public static final EventAttachmentChangesInfo NO_CHANGES = new EventAttachmentChangesInfo(emptyList(), emptyList());

    public boolean wasChanges() {
        return !(removeAttachmentUrls.isEmpty() && newAttachments.isEmpty());
    }
}
