package ru.yandex.calendar.logic.event.attachment;

import javax.annotation.PreDestroy;

import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4;
import ru.yandex.misc.io.http.client.entity.ByteArrayEntity;
import ru.yandex.misc.lang.CharsetUtils;

/**
 * @author Daniel Brylev
 */
public class MulcaGate {
    private final ApacheHttpClient4 httpClient = ApacheHttpClient4.newInstance(Timeout.seconds(3), 20);
    private static final String URL = "http://storagetest.mail.yandex.net:10010/gate";

    @PreDestroy
    public void destroy() {
        httpClient.stop();
    }

    public String put(byte[] entity) {
        return CharsetUtils.decodeAscii(httpClient.post(URL + "/put/calendar", new ByteArrayEntity(entity)));
    }

    public byte[] get(String id) {
        return httpClient.get(URL + "/get/" + id);
    }
}
