package ru.yandex.calendar.logic.event.avail;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.util.base.Cf2;

/**
 * @author Daniel Brylev
 */
public class AvailabilityIntervalsOrRefusal {
    private final Either<AvailabilityIntervals, AvailabilityQueryRefusalReason> result;

    public static AvailabilityIntervalsOrRefusal intervals(AvailabilityIntervals intervals) {
        return new AvailabilityIntervalsOrRefusal(
                Either.<AvailabilityIntervals, AvailabilityQueryRefusalReason>left(intervals));
    }

    public static AvailabilityIntervalsOrRefusal refusal(AvailabilityQueryRefusalReason reason) {
        return new AvailabilityIntervalsOrRefusal(
                Either.<AvailabilityIntervals, AvailabilityQueryRefusalReason>right(reason));
    }

    private AvailabilityIntervalsOrRefusal(Either<AvailabilityIntervals, AvailabilityQueryRefusalReason> result) {
        this.result = result;
    }

    public boolean isRefusal() {
        return result.isRight();
    }

    public AvailabilityIntervals getIntervals() {
        return result.getLeft();
    }

    public Option<AvailabilityIntervals> getIntervalsO() {
        return result.leftO();
    }

    public AvailabilityQueryRefusalReason getRefusalReason() {
        return result.getRight();
    }

    public static Function1B<AvailabilityIntervalsOrRefusal> isRefusalF() {
        return new Function1B<AvailabilityIntervalsOrRefusal>() {
            public boolean apply(AvailabilityIntervalsOrRefusal i) {
                return i.isRefusal();
            }
        };
    }

    public static Function<AvailabilityIntervalsOrRefusal, Option<AvailabilityIntervals>> getIntervalsOF() {
        return new Function<AvailabilityIntervalsOrRefusal, Option<AvailabilityIntervals>>() {
            public Option<AvailabilityIntervals> apply(AvailabilityIntervalsOrRefusal i) {
                return i.getIntervalsO();
            }
        };
    }

    public static Function<AvailabilityIntervalsOrRefusal, AvailabilityIntervals> getIntervalsF() {
        return getIntervalsOF().andThen(Cf2.f(Option::get));
    }

    public static Function<AvailabilityIntervalsOrRefusal, AvailabilityQueryRefusalReason> getRefusalReasonF() {
        return new Function<AvailabilityIntervalsOrRefusal, AvailabilityQueryRefusalReason>() {
            public AvailabilityQueryRefusalReason apply(AvailabilityIntervalsOrRefusal i) {
                return i.getRefusalReason();
            }
        };
    }
}
