package ru.yandex.calendar.logic.event.avail;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.resource.UidOrResourceId;

/**
 * @author dbrylev
 */
public class AvailabilityOverlapOrRefusal {
    private final UidOrResourceId subjectId;
    private final Either<Option<AvailabilityOverlap>, AvailabilityQueryRefusalReason> result;

    public static AvailabilityOverlapOrRefusal overlap(UidOrResourceId subjectId, Option<AvailabilityOverlap> overlap) {
        return new AvailabilityOverlapOrRefusal(subjectId, Either.left(overlap));
    }

    public static AvailabilityOverlapOrRefusal refusal(UidOrResourceId subjectId, AvailabilityQueryRefusalReason reason) {
        return new AvailabilityOverlapOrRefusal(subjectId, Either.right(reason));
    }

    private AvailabilityOverlapOrRefusal(
            UidOrResourceId subjectId, Either<Option<AvailabilityOverlap>, AvailabilityQueryRefusalReason> result)
    {
        this.subjectId = subjectId;
        this.result = result;
    }

    public UidOrResourceId getSubjectId() {
        return subjectId;
    }

    public boolean isRefusal() {
        return result.isRight();
    }

    public Option<AvailabilityOverlap> getOverlap() {
        return result.getLeft();
    }
}
