package ru.yandex.calendar.logic.event.avail;

import ru.yandex.calendar.frontend.caldav.proto.caldav.itip.StatusCode;
import ru.yandex.misc.enums.EnumResolver;


/**
 * @author Stepan Koltsov
 * In Java we love long identifiers.
 */
public enum AvailabilityQueryRefusalReason {
    UNKNOWN_USER(StatusCode.INVALID_NO_AUTHORITY), // not sure, maybe INVALID_USER // stepancheg@
    PERMISSION_DENIED(StatusCode.INVALID_NO_AUTHORITY),
    ;

    private final StatusCode statusCode;

    private AvailabilityQueryRefusalReason(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public StatusCode getStatusCode() {
        return statusCode;
    }

    public static final EnumResolver<AvailabilityQueryRefusalReason> R =
        EnumResolver.er(AvailabilityQueryRefusalReason.class);

    public String toXmlName() {
        return R.toXmlName(this);
    }
} //~
