package ru.yandex.calendar.logic.event.avail;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * @author Daniel Brylev
 */
public class SubjectId {
    private Either<Email, UidOrResourceId> subjectId;

    private SubjectId(Either<Email, UidOrResourceId> subjectId) {
        this.subjectId = subjectId;
    }

    public boolean isEmail() {
        return subjectId.isLeft();
    }

    public Email getEmail() {
        return subjectId.getLeft();
    }

    public Option<Email> getEmailO() {
        return subjectId.leftO();
    }

    public UidOrResourceId getUidOrResourceId() {
        return subjectId.getRight();
    }

    public Option<UidOrResourceId> getUidOrResourceIdO() {
        return subjectId.rightO();
    }

    public static SubjectId uid(PassportUid uid) {
        return new SubjectId(Either.<Email, UidOrResourceId>right(UidOrResourceId.user(uid)));
    }

    public static SubjectId resourceId(long resourceId) {
        return new SubjectId(Either.<Email, UidOrResourceId>right(UidOrResourceId.resource(resourceId)));
    }

    public static SubjectId email(Email email) {
        return new SubjectId(Either.<Email, UidOrResourceId>left(email));
    }

    public static SubjectId uidOrResourceId(UidOrResourceId subjectId) {
        return subjectId.isUser() ? uid(subjectId.getUid()) : resourceId(subjectId.getResourceId());
    }

}
