package ru.yandex.calendar.logic.event.avail;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author gutman
 */
@ru.yandex.commune.util.serialize.reflect.ReflectionToMultilineStringSerializeMe
public class UserOrResourceAvailabilityIntervals {

    private final UidOrResourceId subjectId;

    private final AvailabilityIntervalsOrRefusal intervalsOrRefusal;

    public static UserOrResourceAvailabilityIntervals intervals(UidOrResourceId subjectId, AvailabilityIntervals intervals) {
        return new UserOrResourceAvailabilityIntervals(subjectId, AvailabilityIntervalsOrRefusal.intervals(intervals));
    }

    public static UserOrResourceAvailabilityIntervals refusal(UidOrResourceId subjectId, AvailabilityQueryRefusalReason reason) {
        return new UserOrResourceAvailabilityIntervals(subjectId, AvailabilityIntervalsOrRefusal.refusal(reason));
    }

    public UserOrResourceAvailabilityIntervals(UidOrResourceId subjectId, AvailabilityIntervalsOrRefusal result) {
        this.subjectId = subjectId;
        this.intervalsOrRefusal = result;
    }

    public boolean isRefusal() {
        return intervalsOrRefusal.isRefusal();
    }

    public Option<AvailabilityIntervals> getIntervalsO() {
        return intervalsOrRefusal.getIntervalsO();
    }

    public AvailabilityIntervalsOrRefusal getIntervalsOrRefusal() {
        return intervalsOrRefusal;
    }

    public UidOrResourceId getSubjectId() {
        return subjectId;
    }

    public static Function1B<UserOrResourceAvailabilityIntervals> isRefusalF() {
        return new Function1B<UserOrResourceAvailabilityIntervals>() {
            public boolean apply(UserOrResourceAvailabilityIntervals x) {
                return x.isRefusal();
            }
        };
    }

    public static Function<UserOrResourceAvailabilityIntervals, ListF<AvailabilityInterval>> getUnmergedF() {
        return getIntervalsF().andThen(new Function<AvailabilityIntervals, ListF<AvailabilityInterval>>() {
            public ListF<AvailabilityInterval> apply(AvailabilityIntervals is) {
                return is.unmerged();
            }
        });
    }

    public static Function<UserOrResourceAvailabilityIntervals, AvailabilityIntervals> getIntervalsF() {
        return getIntervalsOF().andThen(Cf2.f(Option::get));
    }

    public static Function<UserOrResourceAvailabilityIntervals, Option<AvailabilityIntervals>> getIntervalsOF() {
        return getIntervalsOrRefusalF().andThen(AvailabilityIntervalsOrRefusal.getIntervalsOF());
    }

    public static Function<UserOrResourceAvailabilityIntervals, AvailabilityIntervalsOrRefusal> getIntervalsOrRefusalF() {
        return new Function<UserOrResourceAvailabilityIntervals, AvailabilityIntervalsOrRefusal>() {
            public AvailabilityIntervalsOrRefusal apply(UserOrResourceAvailabilityIntervals x) {
                return x.getIntervalsOrRefusal();
            }
        };
    }

    public static Function<UserOrResourceAvailabilityIntervals, PassportUid> getUidF() {
        return new Function<UserOrResourceAvailabilityIntervals, PassportUid>() {
            public PassportUid apply(UserOrResourceAvailabilityIntervals x) {
                return x.subjectId.getUid();
            }
        };
    }

    public static Function<UserOrResourceAvailabilityIntervals, UidOrResourceId> getUserOrResourceF() {
        return new Function<UserOrResourceAvailabilityIntervals, UidOrResourceId>() {
            public UidOrResourceId apply(UserOrResourceAvailabilityIntervals x) {
                return x.subjectId;
            }
        };
    }

    public static Function<UidOrResourceId, UserOrResourceAvailabilityIntervals> refusalF(
            final AvailabilityQueryRefusalReason reason)
    {
        return new Function<UidOrResourceId, UserOrResourceAvailabilityIntervals>() {
            public UserOrResourceAvailabilityIntervals apply(UidOrResourceId id) {
                return refusal(id, reason);
            }
        };
    }
}
