package ru.yandex.calendar.logic.event.avail.absence;

import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Value;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

import ru.yandex.calendar.logic.user.Language;
import ru.yandex.inside.passport.login.PassportLogin;
import ru.yandex.misc.lang.DefaultObject;

@Value
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class Absence extends DefaultObject {
    long externalId;
    PassportLogin login;
    LocalDateTime start;
    LocalDateTime end;
    boolean fullDay;
    AbsenceType type;
    String comment;
    boolean workInAbsence;

    public Absence(long externalId, PassportLogin login, LocalDate start, LocalDate end, AbsenceType type, String comment,
                   boolean workInAbsence) {
        this(externalId, login, start.toLocalDateTime(LocalTime.MIDNIGHT), end.toLocalDateTime(LocalTime.MIDNIGHT),
            true, type, comment, workInAbsence);
    }

    private Instant getStartOrEnd(LocalDateTime startOrEnd, DateTimeZone tz) {
        return isFullDay()
                ? startOrEnd.toDateTime(tz).toInstant()
                : startOrEnd.toDateTime(DateTimeZone.UTC).toInstant();
    }

    public Instant getStart(DateTimeZone tz) {
        return getStartOrEnd(start, tz);
    }

    public Instant getEnd(DateTimeZone tz) {
        return getStartOrEnd(end, tz);
    }

    public String getEventName(Language lang) {
        return type.getEventName().getName(lang);
    }
}
